# Phogo Insurance Website

## Overview

This is a Flask-based website for Phogo Insurance, a Kenyan insurance company. The application serves as a professional business website with informational pages about the company's services and a contact form for customer inquiries. The site showcases various insurance products including auto, health, life, property, and business insurance, with a focus on providing comprehensive coverage solutions.

## User Preferences

Preferred communication style: Simple, everyday language.

## System Architecture

**Web Framework**: Flask with Python serves as the core web application framework, providing routing, templating, and form handling capabilities. This choice offers simplicity and flexibility for a small-to-medium business website.

**Template Engine**: Jinja2 templating (built into Flask) handles server-side rendering with a base template inheritance pattern. All pages extend from `base.html` for consistent layout and navigation.

**Form Handling**: WTForms with Flask-WTF provides form validation and CSRF protection. The contact form includes comprehensive validation for name, email, phone, service selection, and message fields with appropriate error handling.

**Frontend Framework**: Bootstrap 5 provides responsive design and UI components, complemented by Font Awesome icons and Google Fonts (Inter). Custom CSS variables maintain consistent branding with a primary blue color scheme.

**Security**: CSRF protection is implemented via Flask-WTF, and the application uses environment variables for sensitive configuration like session secrets.

**Static Assets**: Standard Flask static file serving handles CSS, JavaScript, and image assets from the `/static` directory.

**Logging**: Python's built-in logging module captures application events and form submissions for monitoring and debugging purposes.

## External Dependencies

**CDN Resources**:
- Bootstrap 5.3.2 CSS and JavaScript framework
- Font Awesome 6.4.0 for icons
- Google Fonts (Inter typeface)

**Python Packages**:
- Flask web framework
- Flask-WTF for form handling and CSRF protection  
- WTForms for form validation

**Development Environment**: The application is configured to run on host `0.0.0.0` port `5000` with debug mode enabled for development purposes.

**Email Integration**: The contact form currently logs submissions but is designed to integrate with email services or database storage for production use.